/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;

public class ActionOnCallbackPower
extends Power {
    private final Consumer<Entity> entityActionRespawned;
    private final Consumer<Entity> entityActionRemoved;
    private final Consumer<Entity> entityActionChosen;
    private final Consumer<Entity> entityActionLost;
    private final Consumer<Entity> entityActionAdded;
    private final boolean executeChosenWhenOrb;

    public ActionOnCallbackPower(PowerType<?> type, PlayerEntity player, Consumer<Entity> entityActionRespawned, Consumer<Entity> entityActionRemoved, Consumer<Entity> entityActionChosen, Consumer<Entity> entityActionLost, Consumer<Entity> entityActionAdded, boolean executeChosenWhenOrb) {
        super(type, player);
        this.entityActionRespawned = entityActionRespawned;
        this.entityActionRemoved = entityActionRemoved;
        this.entityActionChosen = entityActionChosen;
        this.entityActionLost = entityActionLost;
        this.entityActionAdded = entityActionAdded;
        this.executeChosenWhenOrb = executeChosenWhenOrb;
    }

    @Override
    public void onRespawn() {
        if (this.entityActionRespawned != null) {
            this.entityActionRespawned.accept((Entity)this.player);
        }
    }

    @Override
    public void onChosen(boolean isOrbOfOrigin) {
        if (this.entityActionChosen != null && (!isOrbOfOrigin || this.executeChosenWhenOrb)) {
            this.entityActionChosen.accept((Entity)this.player);
        }
    }

    @Override
    public void onRemoved() {
        if (this.entityActionRemoved != null) {
            this.entityActionRemoved.accept((Entity)this.player);
        }
    }

    @Override
    public void onLost() {
        if (this.entityActionLost != null) {
            this.entityActionLost.accept((Entity)this.player);
        }
    }

    @Override
    public void onAdded() {
        if (this.entityActionAdded != null) {
            this.entityActionAdded.accept((Entity)this.player);
        }
    }
}

